%define ver 0.4.1
%define rel 1

Summary: A GNOME/GTK+ front-end to the wvdial internet dialler.
Name: gtkdial
Version: %{ver}
Release: %{rel}
License: GPL
Requires: wvdial >= 1.0 gnome-core >= 1.0.60
Group: Applications/Internet
Source: http://www.gtnorthern,demon.co.uk/gtkdial-%{ver}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Vendor: Principia Systems
Packager: Mike Newman <packages@principia-systems.co.uk>

%define prefix /usr
%define sysconfdir /etc

%description
Gtkdial allows the user to control an internet connection using a small app on the GNOME desktop. It detects default settings from the wvdial.conf file, and uses wvdial to control the connection. Issues regarding the use of wvdial by non-root users are addressed at http://www.worldvisions.ca

Install Gtkdial if you want to simply control an internet connection via GNOME.

%prep
%setup

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS TODO README ChangeLog
%{prefix}/bin/gtkdial
%{prefix}/share/pixmaps/gtkdial/*.png
%{prefix}/share/sounds/gtkdial/*.wav
%{sysconfdir}/sound/events/*
%{prefix}/share/gnome/apps/Internet/Gtkdial.desktop
%{prefix}/share/gnome/help/gtkdial/*/*.html
%{prefix}/share/gnome/help/gtkdial/*/*.jpg
%{prefix}/share/gnome/help/gtkdial/*/topic.dat
%{prefix}/share/locale/*/LC_MESSAGES/*.mo
